package org.beast.security.web.access;

import lombok.extern.slf4j.Slf4j;
import org.beast.data.message.ErrorMessageSource;
import org.beast.data.message.StandardErrors;
import org.beast.web.servlet.error.AbstractExceptionAdvice;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * spring webmvc层 处理异常
 *
 * 参考ExceptionTranslationFilter实现 再mvc层进行提前拦截了
 */
@RestControllerAdvice
@Slf4j
public class AccessHandlerExceptionAdvice extends AbstractExceptionAdvice {

//    private AuthenticationEntryPoint authenticationEntryPoint;
//    private AccessDeniedHandler accessDeniedHandler = new AccessDeniedHandlerImpl();


    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public AccessHandlerExceptionAdvice(ErrorMessageSource errorMessageSource
//                                        AuthenticationEntryPoint authenticationEntryPoint
    ) {
        super(errorMessageSource);
//        this.authenticationEntryPoint = authenticationEntryPoint;
    }

//    @ExceptionHandler({AuthenticationException.class})
//    public ModelAndView handleAuthenticationException(AuthenticationException e, HttpServletRequest request, HttpServletResponse response) {
//
//    }
    @ExceptionHandler({AccessDeniedException.class})
    public ModelAndView handleAccessDeniedException(AccessDeniedException exception, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.warn("AccessDenied: {} ", getRequestInfo(request), exception);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean isAnonymous = this.authenticationTrustResolver.isAnonymous(authentication);

        if (isAnonymous) {

            return returnErrorMessage(StandardErrors.UNAUTHENTICATED.toError(), request, response);
        }
//        else {
//            this.accessDeniedHandler.handle(request, response, exception);
//        }

        return returnErrorMessage(StandardErrors.ACCESS_DENIED.toError(), request, response);
    }


//    private void sendStartAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws ServletException, IOException {
//        this.authenticationEntryPoint.commence(request, response, exception);
//    }

}
