/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import javax.servlet.http.HttpServletRequest;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.codec.SNSUserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.resolver.CompositeTokenValueWebExtractor;
import org.beast.security.web.resolver.CookieTokenValueWebExtractor;
import org.beast.security.web.resolver.HeaderTokenValueWebExtractor;
import org.beast.security.web.resolver.WebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class SNSUserTokenWebExtractor
implements WebExtractor<SNSUserToken> {
    private static final Logger log = LoggerFactory.getLogger(SNSUserTokenWebExtractor.class);
    private WebExtractor<String> tokenStringWebExtractor = CompositeTokenValueWebExtractor.of(new HeaderTokenValueWebExtractor("X-SNS-U-Token"), new CookieTokenValueWebExtractor("sns-u-token"));
    private static final SNSUserTokenCodec CODEC = new SNSUserTokenCodec();

    @Override
    public SNSUserToken extract(MethodParameter parameter, NativeWebRequest webRequest) {
        String tokenString = this.tokenStringWebExtractor.extract(parameter, webRequest);
        return this.parseToken(tokenString);
    }

    @Override
    public SNSUserToken extract(HttpServletRequest servletRequest) {
        String tokenString = this.tokenStringWebExtractor.extract(servletRequest);
        return this.parseToken(tokenString);
    }

    public SNSUserToken parseToken(String tokenString) {
        SNSUserToken snsUserToken;
        if (ObjectUtils.isEmpty((Object)tokenString)) {
            return null;
        }
        try {
            snsUserToken = (SNSUserToken)CODEC.decode(tokenString);
            snsUserToken.verify();
        }
        catch (TokenException e) {
            log.warn("SNSUserToken extract exception: {}", (Object)tokenString, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.warn("SNSUserToken extract failure: {}", (Object)tokenString, (Object)e);
            return null;
        }
        return snsUserToken;
    }
}

