/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import javax.servlet.http.HttpServletRequest;
import org.beast.security.core.AnonymousToken;
import org.beast.security.core.codec.AnonymousTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.resolver.CookieTokenValueWebExtractor;
import org.beast.security.web.resolver.WebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class AnonymousTokenExtractor
implements WebExtractor<AnonymousToken> {
    private static final Logger log = LoggerFactory.getLogger(AnonymousTokenExtractor.class);
    private static final AnonymousTokenCodec CODEC = new AnonymousTokenCodec();
    private WebExtractor<String> tokenStringWebExtractor = new CookieTokenValueWebExtractor("anonymous-ticket");

    @Override
    public AnonymousToken extract(HttpServletRequest servletRequest) {
        String tokenString = this.tokenStringWebExtractor.extract(servletRequest);
        return this.parseToken(tokenString);
    }

    public AnonymousToken parseToken(String tokenString) {
        AnonymousToken anonymousToken;
        if (ObjectUtils.isEmpty((Object)tokenString)) {
            return null;
        }
        try {
            anonymousToken = (AnonymousToken)CODEC.decode(tokenString);
            anonymousToken.verify();
        }
        catch (TokenException e) {
            log.warn("AnonymousToken extract exception:  {}", (Object)tokenString, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.warn("AnonymousToken extract failure: {}", (Object)tokenString, (Object)e);
            return null;
        }
        return anonymousToken;
    }
}

