/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import javax.servlet.http.HttpServletRequest;
import org.beast.security.core.UserToken;
import org.beast.security.core.codec.UserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.resolver.CompositeTokenValueWebExtractor;
import org.beast.security.web.resolver.CookieTokenValueWebExtractor;
import org.beast.security.web.resolver.HeaderTokenValueWebExtractor;
import org.beast.security.web.resolver.WebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class UserTokenWebExtractor
implements WebExtractor<UserToken> {
    private static final Logger log = LoggerFactory.getLogger(UserTokenWebExtractor.class);
    private WebExtractor<String> tokenStringWebExtractor;
    private final UserTokenCodec codec = new UserTokenCodec();

    public UserTokenWebExtractor() {
        this.tokenStringWebExtractor = CompositeTokenValueWebExtractor.of(new HeaderTokenValueWebExtractor("X-U-Token"), new CookieTokenValueWebExtractor("u-token"));
    }

    @Override
    public UserToken extract(MethodParameter parameter, NativeWebRequest webRequest) {
        String tokenString = this.tokenStringWebExtractor.extract(parameter, webRequest);
        return this.parseToken(tokenString);
    }

    @Override
    public UserToken extract(HttpServletRequest servletRequest) {
        String tokenString = this.tokenStringWebExtractor.extract(servletRequest);
        return this.parseToken(tokenString);
    }

    public UserToken parseToken(String tokenString) {
        if (ObjectUtils.isEmpty((Object)tokenString)) {
            return null;
        }
        UserToken userToken = null;
        try {
            userToken = this.codec.decode(tokenString);
            userToken.verify();
        }
        catch (TokenException e) {
            log.warn("UserToken extract exception, token: {}", (Object)tokenString, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.warn("UserToken extract failure, token:{}", (Object)tokenString, (Object)e);
            return null;
        }
        return userToken;
    }
}

