/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import java.util.Objects;
import org.beast.security.core.AnonymousToken;
import org.beast.security.core.annotation.AnonymousTokenValue;
import org.beast.security.web.resolver.AbstractTokenArgumentResolver;
import org.beast.security.web.resolver.AnonymousTokenExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

public class AnonymousTokenArgumentResolver
extends AbstractTokenArgumentResolver<AnonymousTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(AnonymousTokenArgumentResolver.class);
    private AnonymousTokenExtractor anonymousTokenExtractor = new AnonymousTokenExtractor();

    public AnonymousTokenArgumentResolver() {
        super(AnonymousTokenValue.class);
    }

    @Override
    public boolean isRequired(AnonymousTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new IllegalArgumentException("anonymous-token is required");
    }

    @Override
    @Nullable
    protected Object resolveValue(AnonymousTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        AnonymousToken anonymousToken = (AnonymousToken)this.anonymousTokenExtractor.extract(parameter, webRequest);
        if (Objects.isNull(anonymousToken)) {
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return anonymousToken.getAnonymousId();
        }
        return anonymousToken;
    }
}

