/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractTokenArgumentResolver<A extends Annotation>
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractTokenArgumentResolver.class);
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Class<A> annotationClass;

    public AbstractTokenArgumentResolver(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(this.annotationClass);
    }

    public abstract boolean isRequired(A var1);

    public A resolveAnnotation(MethodParameter parameter) {
        return (A)parameter.getParameterAnnotation(this.annotationClass);
    }

    @Nullable
    public Object resolveArgument(@NonNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        MethodParameter nestedParameter;
        Object arg;
        A annotation = this.resolveAnnotation(parameter);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)("No " + this.annotationClass.getSimpleName() + " annotation"));
        String name = parameter.getParameterName();
        if (name == null) {
            name = "";
        }
        if ((arg = this.resolveValue(annotation, nestedParameter = parameter.nestedIfOptional(), webRequest)) == null) {
            if (this.isRequired(annotation) && !nestedParameter.isOptional()) {
                this.handleMissingValue(parameter);
            }
            arg = this.handleNullValue(arg, nestedParameter.getNestedParameterType());
        }
        if (binderFactory != null) {
            WebDataBinder binder = binderFactory.createBinder(webRequest, null, name);
            try {
                arg = binder.convertIfNecessary(arg, parameter.getParameterType(), parameter);
            }
            catch (ConversionNotSupportedException ex) {
                throw new MethodArgumentConversionNotSupportedException(arg, ex.getRequiredType(), name, parameter, ex.getCause());
            }
            catch (TypeMismatchException ex) {
                throw new MethodArgumentTypeMismatchException(arg, ex.getRequiredType(), name, parameter, ex.getCause());
            }
        }
        return arg;
    }

    protected abstract void handleMissingValue(MethodParameter var1) throws ServletRequestBindingException;

    @Nullable
    private Object handleNullValue(@Nullable Object value, Class<?> paramType) {
        if (value == null && Boolean.TYPE.equals(paramType)) {
            return Boolean.FALSE;
        }
        return value;
    }

    @Nullable
    protected abstract Object resolveValue(A var1, MethodParameter var2, NativeWebRequest var3) throws ServletRequestBindingException;
}

