package org.beast.security.web.servlet;


import lombok.extern.slf4j.Slf4j;
import org.beast.data.message.ErrorMessageSource;
import org.beast.data.message.StandardErrors;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.web.servlet.error.AbstractExceptionAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
@RestControllerAdvice
public class AuthenticationConstraintExceptionAdvice extends AbstractExceptionAdvice {


    public AuthenticationConstraintExceptionAdvice(ErrorMessageSource errorMessageSource) {
        super(errorMessageSource);
    }

    @ExceptionHandler({UnauthenticatedException.class})
    public ModelAndView handleUnauthenticated(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.warn("{} unauthenticated ", getRequestInfo(request), e);
        return returnErrorMessage(StandardErrors.UNAUTHENTICATED.toError(), request, response);
    }
}
