package org.beast.security.web.resolver;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;

import javax.servlet.http.HttpServletRequest;

public class HeaderTokenValueWebExtractor implements WebExtractor<String>{

    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    private String headerName;

    public HeaderTokenValueWebExtractor(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public String extract(MethodParameter parameter, NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
        return this.extract(servletRequest);
    }

    @Override
    public String extract(HttpServletRequest servletRequest) {
        String value = null;
        if (servletRequest != null) {
            String headerValue = servletRequest.getHeader(this.headerName);
            if (headerValue != null) {
                value = this.urlPathHelper.decodeRequestString(servletRequest, headerValue);
            }
        }
        return value;
    }
}
