package org.beast.security.web.resolver;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieTokenValueWebExtractor implements WebExtractor<String> {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    private String cookieName;

    public CookieTokenValueWebExtractor(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String extract(MethodParameter parameter, NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
        return this.extract(servletRequest);
    }

    @Override
    public String extract(HttpServletRequest servletRequest) {
        String value = null;
        if (servletRequest != null) {
            Cookie cookieValue = WebUtils.getCookie(servletRequest, this.cookieName);
            if (cookieValue != null) {
                value = this.urlPathHelper.decodeRequestString(servletRequest, cookieValue.getValue());
            }
        }
        return value;
    }
}
