package org.beast.security.web.jackson;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.beast.security.core.auth.permission.WildcardPermission;

import java.io.IOException;

public class PermissionModule extends SimpleModule {

    public PermissionModule() {
        super("Permission");
        this.addSerializer(WildcardPermission.class, new ToStringSerializer(WildcardPermission.class));
        this.addDeserializer(WildcardPermission.class, new WildcardPermissionDeserializer());
    }

    public static class WildcardPermissionDeserializer extends FromStringDeserializer<WildcardPermission> {

        protected WildcardPermissionDeserializer() {
            super(WildcardPermission.class);
        }

        @Override
        protected WildcardPermission _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return new WildcardPermission(value);
        }
    }
}
