package org.beast.security.web.context;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.UserToken;
import org.beast.security.web.resolver.*;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

@Slf4j
public class UserSecurityContextRepository implements SecurityContextRepository {

    private UserTokenWebExtractor userTokenWebExtractor;


    public UserSecurityContextRepository() {
        super();
        this.userTokenWebExtractor = new UserTokenWebExtractor();
    }

    @Override
    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest servletRequest = requestResponseHolder.getRequest();
        UserToken userToken = userTokenWebExtractor.extract(servletRequest);
        if (Objects.isNull(userToken)) {
            return SecurityContextHolder.createEmptyContext();
        }
        Authentication authentication = new UserAuthorizationToken(userToken);
        authentication.setAuthenticated(true);
        return new SecurityContextImpl(authentication);

    }

    @Override
    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {

    }

    @Override
    public boolean containsContext(HttpServletRequest request) {
        UserToken userToken = userTokenWebExtractor.extract(request);
        return Objects.nonNull(userToken);
    }
}
