package org.beast.security.web.context;

import org.beast.security.core.UserToken;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

public class UserAuthorizationToken extends AbstractAuthenticationToken {

    private UserToken token;

    public UserAuthorizationToken(UserToken token) {
        super(null);
        this.token = token;
        setAuthenticated(true);
    }
    public UserAuthorizationToken(UserToken token, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.token = token;
        setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return token;
    }

    @Override
    public Object getPrincipal() {
        return token;
    }

    public long getUid() {
        return token.getUid();
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return super.getAuthorities();
    }
}
