package org.beast.security.web.resolver;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.UserToken;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.core.codec.UserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.annotation.UserTokenValue;
import org.beast.web.util.WebUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

@Deprecated
@Slf4j
public class UserTokenArgumentResolver extends AbstractTokenArgumentResolver<UserTokenValue>{

    private HeaderTokenValueWebExtractor headerTokenValueWebExtractor;
    private CookieTokenValueWebExtractor cookieTokenValueWebExtractor;

    private final UserTokenCodec codec = new UserTokenCodec();

    public UserTokenArgumentResolver() {
        super(UserTokenValue.class);
        this.headerTokenValueWebExtractor = new HeaderTokenValueWebExtractor(WebUtils.HEADER_USER_TOKEN);
        this.cookieTokenValueWebExtractor = new CookieTokenValueWebExtractor(WebUtils.COOKIE_USER_TOKEN);
    }

    @Override
    public boolean isRequired(UserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new UnauthenticatedException("token missing");
    }

    @Override
    protected Object resolveValue(UserTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        String tokenString = this.headerTokenValueWebExtractor.extract(parameter, webRequest);
        if (tokenString == null) {
            tokenString = this.cookieTokenValueWebExtractor.extract(parameter, webRequest);
        }
        UserToken userToken;
        try {
            userToken = codec.decode(tokenString);
            userToken.verify();
        } catch (TokenException e) {
            log.warn("token exception", e);
            return null;
        } catch (Exception e) {
            log.warn("token invalid", e);
            return null;
        }
        if (Long.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return userToken.getUid();
        } else {
            return userToken;
        }
    }
}
