package org.beast.security.web.resolver;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;

public class CompositeTokenValueWebExtractor implements WebExtractor<String> {

    private List<WebExtractor<String>> extractors;

    private CompositeTokenValueWebExtractor(WebExtractor<String> ...extractors) {
        this.extractors = List.of(extractors);
    }

    public static CompositeTokenValueWebExtractor of(WebExtractor<String> ...extractors) {
        return new CompositeTokenValueWebExtractor(extractors);
    }


    @Override
    public String extract(HttpServletRequest servletRequest) {
        return extractors.stream().map((extractor) -> {
            return extractor.extract(servletRequest);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }
}
