/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import org.beast.security.core.UserToken;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.core.codec.UserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.annotation.UserTokenValue;
import org.beast.security.web.resolver.AbstractTokenArgumentResolver;
import org.beast.security.web.resolver.CookieTokenValueWebExtractor;
import org.beast.security.web.resolver.HeaderTokenValueWebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

public class UserTokenArgumentResolver
extends AbstractTokenArgumentResolver<UserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(UserTokenArgumentResolver.class);
    private HeaderTokenValueWebExtractor headerTokenValueWebExtractor;
    private CookieTokenValueWebExtractor cookieTokenValueWebExtractor;
    private final UserTokenCodec codec = new UserTokenCodec();

    public UserTokenArgumentResolver() {
        super(UserTokenValue.class);
        this.headerTokenValueWebExtractor = new HeaderTokenValueWebExtractor("X-U-Token");
        this.cookieTokenValueWebExtractor = new CookieTokenValueWebExtractor("u-token");
    }

    @Override
    public boolean isRequired(UserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new UnauthenticatedException("token missing");
    }

    @Override
    protected Object resolveValue(UserTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        UserToken userToken;
        String tokenString = this.headerTokenValueWebExtractor.extract(parameter, webRequest);
        if (tokenString == null) {
            tokenString = this.cookieTokenValueWebExtractor.extract(parameter, webRequest);
        }
        try {
            userToken = this.codec.decode(tokenString);
            userToken.verify();
        }
        catch (TokenException e) {
            log.warn("token exception", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.warn("token invalid", (Throwable)e);
            return null;
        }
        if (Long.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return userToken.getUid();
        }
        return userToken;
    }
}

