/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import java.lang.reflect.AnnotatedElement;
import org.apache.commons.lang3.ArrayUtils;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSTokenType;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.WechatOffiAccountSNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.core.codec.SNSUserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.annotation.SNSUserTokenValue;
import org.beast.security.web.resolver.AbstractTokenArgumentResolver;
import org.beast.security.web.resolver.CookieTokenValueWebExtractor;
import org.beast.security.web.resolver.HeaderTokenValueWebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

public class SNSUserTokenArgumentResolver
extends AbstractTokenArgumentResolver<SNSUserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(SNSUserTokenArgumentResolver.class);
    private static final SNSUserTokenCodec CODEC = new SNSUserTokenCodec();
    private HeaderTokenValueWebExtractor headerTokenValueWebExtractor = new HeaderTokenValueWebExtractor("sns-u-token");
    private CookieTokenValueWebExtractor cookieTokenValueWebExtractor = new CookieTokenValueWebExtractor("X-SNS-U-Token");

    public SNSUserTokenArgumentResolver() {
        super(SNSUserTokenValue.class);
    }

    @Override
    public boolean isRequired(SNSUserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new UnauthenticatedException("sns-user-token missing");
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter.getParameter(), SNSUserTokenValue.class);
    }

    @Override
    public SNSUserTokenValue resolveAnnotation(MethodParameter parameter) {
        return (SNSUserTokenValue)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), SNSUserTokenValue.class);
    }

    @Override
    protected Object resolveValue(SNSUserTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        SNSUserToken snsUserToken;
        String tokenString = this.headerTokenValueWebExtractor.extract(parameter, webRequest);
        if (tokenString == null) {
            tokenString = this.cookieTokenValueWebExtractor.extract(parameter, webRequest);
        }
        Object[] types = annotation.type();
        try {
            snsUserToken = (SNSUserToken)CODEC.decode(tokenString);
            snsUserToken.verify();
        }
        catch (TokenException e) {
            log.warn("token exception", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.warn("token invalid", (Throwable)e);
            return null;
        }
        if (types.length > 0 && !ArrayUtils.contains((Object[])types, (Object)snsUserToken.getType())) {
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return switch (snsUserToken.getType()) {
                case SNSTokenType.WECHAT_WEAPP -> ((WechatWeappSNSUserToken)snsUserToken).getOpenId();
                case SNSTokenType.WECHAT_OFFIACCOUNT -> ((WechatOffiAccountSNSUserToken)snsUserToken).getOpenId();
                case SNSTokenType.BYTEDANCE_BYTEAPP -> ((BytedanceByteappSNSUserToken)snsUserToken).getOpenId();
                default -> null;
            };
        }
        return snsUserToken;
    }
}

