/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import javax.servlet.http.HttpServletRequest;
import org.beast.security.web.resolver.WebExtractor;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;

public class HeaderTokenValueWebExtractor
implements WebExtractor<String> {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private String headerName;

    public HeaderTokenValueWebExtractor(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public String extract(MethodParameter parameter, NativeWebRequest webRequest) {
        String headerValue;
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String value = null;
        if (servletRequest != null && (headerValue = webRequest.getHeader(this.headerName)) != null) {
            value = this.urlPathHelper.decodeRequestString(servletRequest, headerValue);
        }
        return value;
    }
}

