/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.beast.security.web.resolver.WebExtractor;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class CookieTokenValueWebExtractor
implements WebExtractor<String> {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private String cookieName;

    public CookieTokenValueWebExtractor(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String extract(MethodParameter parameter, NativeWebRequest webRequest) {
        Cookie cookieValue;
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String value = null;
        if (servletRequest != null && (cookieValue = WebUtils.getCookie((HttpServletRequest)servletRequest, (String)this.cookieName)) != null) {
            value = this.urlPathHelper.decodeRequestString(servletRequest, cookieValue.getValue());
        }
        return value;
    }
}

