/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import org.beast.security.core.WechatUserToken;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.core.codec.WechatUserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.resolver.AbstractTokenArgumentResolver;
import org.beast.security.web.resolver.WechatUserTokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;

public class WechatUserTokenArgumentResolver
extends AbstractTokenArgumentResolver<WechatUserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(WechatUserTokenArgumentResolver.class);
    private static final String COOKIE_NAME = "sns-u-token";
    private static final String HEADER_NAME = "X-SNS-U-Token";
    private final WechatUserTokenCodec codec = new WechatUserTokenCodec();

    public WechatUserTokenArgumentResolver() {
        super(COOKIE_NAME, HEADER_NAME, WechatUserTokenValue.class);
    }

    @Override
    public boolean isRequired(WechatUserTokenValue annotation) {
        return annotation.token().required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new UnauthenticatedException("token missing");
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        WechatUserToken wechatUserToken;
        try {
            wechatUserToken = (WechatUserToken)this.codec.decode(tokenString);
            wechatUserToken.verify();
        }
        catch (TokenException e) {
            log.warn("token exception", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.warn("token invalid", (Throwable)e);
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return wechatUserToken.getOpenId();
        }
        return wechatUserToken;
    }
}

