/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import org.beast.security.core.BytedanceUserToken;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.core.codec.BytedanceUserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.resolver.AbstractTokenArgumentResolver;
import org.beast.security.web.resolver.BytedanceUserTokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;

public class BytedanceUserTokenArgumentResolver
extends AbstractTokenArgumentResolver<BytedanceUserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(BytedanceUserTokenArgumentResolver.class);
    private static final String COOKIE_NAME = "sns-u-token";
    private static final String HEADER_NAME = "X-SNS-U-Token";
    private final BytedanceUserTokenCodec codec = new BytedanceUserTokenCodec();

    public BytedanceUserTokenArgumentResolver() {
        super(COOKIE_NAME, HEADER_NAME, BytedanceUserTokenValue.class);
    }

    @Override
    public boolean isRequired(BytedanceUserTokenValue annotation) {
        return annotation.token().required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new UnauthenticatedException("token missing");
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        BytedanceUserToken bytedanceUserToken;
        try {
            bytedanceUserToken = (BytedanceUserToken)this.codec.decode(tokenString);
            bytedanceUserToken.verify();
        }
        catch (TokenException e) {
            log.warn("token exception", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.warn("token invalid", (Throwable)e);
            return null;
        }
        return bytedanceUserToken;
    }
}

