/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.core.codec.SNSUserTokenCodec;
import org.beast.security.web.resolver.AbstractTokenArgumentResolver;
import org.beast.security.web.resolver.SNSUserTokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;

public abstract class AbstractSNSUserTokenArgumentResolver<T>
extends AbstractTokenArgumentResolver<SNSUserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSNSUserTokenArgumentResolver.class);
    private static final String COOKIE_NAME = "sns-u-token";
    private static final String HEADER_NAME = "X-SNS-U-Token";
    private final SNSUserTokenCodec codec = new SNSUserTokenCodec();

    public AbstractSNSUserTokenArgumentResolver() {
        super(COOKIE_NAME, HEADER_NAME, SNSUserTokenValue.class);
    }

    @Override
    public boolean isRequired(SNSUserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new UnauthenticatedException("token missing");
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        return this.codec.decode(tokenString);
    }
}

