/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beast.data.message.ErrorMessageSource;
import org.beast.data.message.IError;
import org.beast.data.message.StandardErrors;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.web.servlet.error.AbstractExceptionAdvice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.ModelAndView;

@RestControllerAdvice
public class AuthenticationConstraintExceptionAdvice
extends AbstractExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationConstraintExceptionAdvice.class);

    public AuthenticationConstraintExceptionAdvice(ErrorMessageSource errorMessageSource) {
        super(errorMessageSource);
    }

    @ExceptionHandler(value={UnauthenticatedException.class})
    public ModelAndView handleUnauthenticated(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.warn("{} unauthenticated ", (Object)this.getRequestInfo(request), (Object)e);
        return this.returnErrorMessage((IError)StandardErrors.UNAUTHENTICATED.toError(), request, response);
    }
}

