/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import org.beast.security.core.UserToken;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.core.codec.UserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.web.resolver.AbstractTokenArgumentResolver;
import org.beast.security.web.resolver.UserTokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;

public class UserTokenArgumentResolver
extends AbstractTokenArgumentResolver<UserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(UserTokenArgumentResolver.class);
    private static final String COOKIE_NAME = "u-token";
    private final UserTokenCodec codec = new UserTokenCodec();

    public UserTokenArgumentResolver() {
        super(COOKIE_NAME, UserTokenValue.class);
    }

    @Override
    public boolean isRequired(UserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new UnauthenticatedException("token missing");
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        UserToken userToken = this.codec.decode(tokenString);
        try {
            userToken.verify();
        }
        catch (TokenException e) {
            log.warn("token invalid");
            return null;
        }
        if (Long.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return userToken.getUid();
        }
        return userToken;
    }
}

