/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.guest.resolver;

import jakarta.servlet.http.HttpServletRequest;
import org.beast.security.core.exception.TokenException;
import org.beast.security.guest.GuestToken;
import org.beast.security.guest.codec.GuestTokenCodec;
import org.beast.web.resolver.CookieValueWebExtractor;
import org.beast.web.resolver.WebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class GuestTokenExtractor
implements WebExtractor<GuestToken> {
    private static final Logger log = LoggerFactory.getLogger(GuestTokenExtractor.class);
    public static final String COOKIE_NAME = "guest-token";
    private static final GuestTokenCodec CODEC = new GuestTokenCodec();
    private WebExtractor<String> tokenStringWebExtractor = new CookieValueWebExtractor("guest-token");

    public GuestToken extract(HttpServletRequest servletRequest) {
        String tokenString = (String)this.tokenStringWebExtractor.extract(servletRequest);
        return this.parseToken(tokenString);
    }

    public GuestToken parseToken(String tokenString) {
        GuestToken token;
        if (ObjectUtils.isEmpty((Object)tokenString)) {
            return null;
        }
        try {
            token = (GuestToken)CODEC.decode(tokenString);
            token.verify();
        }
        catch (TokenException e) {
            log.warn("GuestToken extract exception:  {}", (Object)tokenString, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.warn("GuestToken extract failure: {}", (Object)tokenString, (Object)e);
            return null;
        }
        return token;
    }
}

