/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.guest.resolver;

import java.util.Objects;
import org.beast.security.guest.GuestToken;
import org.beast.security.guest.annotation.GuestTokenValue;
import org.beast.security.guest.resolver.GuestTokenExtractor;
import org.beast.security.web.resolver.AbstractArgumentResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

public class GuestTokenArgumentResolver
extends AbstractArgumentResolver<GuestTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(GuestTokenArgumentResolver.class);
    private GuestTokenExtractor extractor = new GuestTokenExtractor();

    public GuestTokenArgumentResolver() {
        super(GuestTokenValue.class);
    }

    public boolean isRequired(GuestTokenValue annotation) {
        return annotation.required();
    }

    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new IllegalArgumentException("guest-token is required");
    }

    @Nullable
    protected Object resolveValue(GuestTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        GuestToken token = (GuestToken)this.extractor.extract(parameter, webRequest);
        if (Objects.isNull(token)) {
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return token.getGuestId();
        }
        return token;
    }
}

