/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.guest;

import java.time.Instant;
import java.util.Objects;
import org.beast.security.core.TokenNamed;
import org.beast.security.core.exception.TokenExpiredException;

public class GuestToken
implements TokenNamed {
    private static final String NAME = "GuestToken";
    private String guestId;
    private Instant issuedAt;
    private Instant expiresAt;

    public String name() {
        return NAME;
    }

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (Objects.isNull(this.expiresAt) || !this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        }
    }

    public String getGuestId() {
        return this.guestId;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void setGuestId(String guestId) {
        this.guestId = guestId;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuestToken)) {
            return false;
        }
        GuestToken other = (GuestToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$guestId = this.getGuestId();
        String other$guestId = other.getGuestId();
        if (this$guestId == null ? other$guestId != null : !this$guestId.equals(other$guestId)) {
            return false;
        }
        Instant this$issuedAt = this.getIssuedAt();
        Instant other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt)) {
            return false;
        }
        Instant this$expiresAt = this.getExpiresAt();
        Instant other$expiresAt = other.getExpiresAt();
        return !(this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuestToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $guestId = this.getGuestId();
        result = result * 59 + ($guestId == null ? 43 : $guestId.hashCode());
        Instant $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        Instant $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        return result;
    }

    public String toString() {
        return "GuestToken(guestId=" + this.getGuestId() + ", issuedAt=" + this.getIssuedAt() + ", expiresAt=" + this.getExpiresAt() + ")";
    }
}

