package org.beast.security.guest.resolver;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.guest.annotation.GuestTokenValue;
import org.beast.security.web.resolver.AbstractArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

import java.util.Objects;

@Slf4j
public class GuestTokenArgumentResolver extends AbstractArgumentResolver<GuestTokenValue> {

    private GuestTokenExtractor extractor;

    public GuestTokenArgumentResolver() {
        super(GuestTokenValue.class);
        this.extractor = new GuestTokenExtractor();
    }

    @Override
    public boolean isRequired(GuestTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new IllegalArgumentException("guest-token is required");
    }

    @Nullable
    @Override
    protected Object resolveValue(GuestTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        var token = extractor.extract(parameter, webRequest);
        if (Objects.isNull(token)) {
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return token.getGuestId();
        }
        return token;
    }
}
