package org.beast.security.guest;

import lombok.Data;
import org.beast.security.core.TokenNamed;
import org.beast.security.core.exception.TokenExpiredException;

import java.time.Instant;
import java.util.Objects;

@Data
public class GuestToken implements TokenNamed {

    private static final String NAME = "GuestToken";

    /**
     * 来宾ID
     */
    private String guestId;


    //发行时间
    private Instant issuedAt;

    //于过期
    private Instant expiresAt;

    @Override
    public String name() {
        return NAME;
    }


    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }
    public void verify() {
        Instant now = Instant.now();
        if (Objects.isNull(this.expiresAt) || !this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        };
    }
}
