package org.beast.security.guest.resolver;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.exception.TokenException;
import org.beast.security.guest.GuestToken;
import org.beast.security.guest.codec.GuestTokenCodec;
import org.beast.security.web.resolver.CookieTokenValueWebExtractor;
import org.beast.security.web.resolver.WebExtractor;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletRequest;

@Slf4j
public class GuestTokenExtractor implements WebExtractor<GuestToken>{

    public static final String COOKIE_NAME = "guest-token";
    private final static GuestTokenCodec CODEC = new GuestTokenCodec();

    private WebExtractor<String> tokenStringWebExtractor;

    public GuestTokenExtractor() {
        this.tokenStringWebExtractor = new CookieTokenValueWebExtractor(
                COOKIE_NAME
        );
    }

    @Override
    public GuestToken extract(HttpServletRequest servletRequest) {
        var tokenString = this.tokenStringWebExtractor.extract(servletRequest);
        return parseToken(tokenString);
    }

    public GuestToken parseToken(String tokenString) {
        if (ObjectUtils.isEmpty(tokenString)) {
            return null;
        }
        GuestToken token;
        try {
            token = CODEC.decode(tokenString);
            token.verify();
        } catch (TokenException e) {
            log.warn("GuestToken extract exception:  {}", tokenString, e);
            return null;
        } catch (Exception e) {
            log.warn("GuestToken extract failure: {}", tokenString, e);
            return null;
        }
        return token;
    }
}
