/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.graphql.interceptor;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.codec.SNSUserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;

public class SecurityWebGraphQlInterceptor
implements WebGraphQlInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SecurityWebGraphQlInterceptor.class);
    private static final SNSUserTokenCodec CODEC = new SNSUserTokenCodec();

    public Mono<WebGraphQlResponse> intercept(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        request.configureExecutionInput((executionInput, builder) -> {
            String tokenString;
            SNSUserToken snsUserToken;
            HashMap context = Maps.newHashMap();
            HttpHeaders headers = request.getHeaders();
            if (headers.containsKey((Object)"X-SNS-U-Token") && Objects.nonNull(snsUserToken = this.parseToken(tokenString = headers.getFirst("X-SNS-U-Token")))) {
                context.put("X-SNS-U-Token", snsUserToken);
            }
            return builder.graphQLContext((Map)context).build();
        });
        return chain.next(request);
    }

    public SNSUserToken parseToken(String tokenString) {
        SNSUserToken snsUserToken;
        if (ObjectUtils.isEmpty((Object)tokenString)) {
            return null;
        }
        try {
            snsUserToken = (SNSUserToken)CODEC.decode(tokenString);
            snsUserToken.verify();
        }
        catch (TokenException e) {
            log.warn("SNSUserToken extract exception: {}", (Object)tokenString, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.warn("SNSUserToken extract failure: {}", (Object)tokenString, (Object)e);
            return null;
        }
        return snsUserToken;
    }
}

