package org.beast.security.graphql;

import org.beast.graphql.configuration.BeastGraphqlAutoConfiguration;
import org.beast.security.graphql.interceptor.SecurityWebGraphQlInterceptor;
import org.beast.security.graphql.resolver.SNSUserTokenArgumentResolver;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureAfter(BeastGraphqlAutoConfiguration.class)
@Configuration(proxyBeanMethods = false)
public class SecurityGraphqlAutoConfiguration {

    @Bean
    public SecurityWebGraphQlInterceptor securityWebGraphQlInterceptor() {
        return new SecurityWebGraphQlInterceptor();
    }


    @Bean
    public SNSUserTokenArgumentResolver snsUserTokenArgumentResolver() {
        return new SNSUserTokenArgumentResolver();
    }
}
