/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.graphql.resolver;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSTokenType;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.WechatOffiAccountSNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.beast.security.core.annotation.SNSUserTokenValue;
import org.beast.security.core.auth.UnauthenticatedException;
import org.beast.security.graphql.resolver.AbstractTokenArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SNSUserTokenArgumentResolver
extends AbstractTokenArgumentResolver<SNSUserTokenValue> {
    public SNSUserTokenArgumentResolver() {
        super(SNSUserTokenValue.class);
    }

    @Override
    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter.getParameter(), SNSUserTokenValue.class);
    }

    @Override
    public SNSUserTokenValue resolveAnnotation(MethodParameter parameter) {
        return (SNSUserTokenValue)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), SNSUserTokenValue.class);
    }

    @Override
    public boolean isRequired(SNSUserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) {
        throw new UnauthenticatedException("SNSUserToken is missing");
    }

    @Override
    @Nullable
    protected Object resolveValue(SNSUserTokenValue annotation, MethodParameter parameter, DataFetchingEnvironment environment) {
        GraphQLContext context = environment.getGraphQlContext();
        SNSUserToken snsUserToken = (SNSUserToken)context.get((Object)"X-SNS-U-Token");
        if (Objects.isNull(snsUserToken)) {
            return null;
        }
        Object[] requiredTypes = annotation.type();
        if (requiredTypes.length > 0 && !ArrayUtils.contains((Object[])requiredTypes, (Object)snsUserToken.getType())) {
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return switch (snsUserToken.getType()) {
                case SNSTokenType.WECHAT_WEAPP -> ((WechatWeappSNSUserToken)snsUserToken).getOpenid();
                case SNSTokenType.WECHAT_OFFIACCOUNT -> ((WechatOffiAccountSNSUserToken)snsUserToken).getOpenid();
                case SNSTokenType.BYTEDANCE_BYTEAPP -> ((BytedanceByteappSNSUserToken)snsUserToken).getOpenid();
                default -> null;
            };
        }
        return snsUserToken;
    }
}

