/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import java.util.Objects;
import org.beast.security.core.AlipayAliappSNSToken;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSType;
import org.beast.security.core.TokenNamed;
import org.beast.security.core.WechatOffiaccountSNSUserToken;
import org.beast.security.core.WechatUnionSNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.beast.security.core.exception.TokenExpiredException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AlipayAliappSNSToken.class, name="ALIPAY_ALIAPP"), @JsonSubTypes.Type(value=WechatWeappSNSUserToken.class, name="WECHAT_WEAPP"), @JsonSubTypes.Type(value=WechatOffiaccountSNSUserToken.class, name="WECHAT_OFFIACCOUNT"), @JsonSubTypes.Type(value=WechatUnionSNSUserToken.class, name="WECHAT_UNION"), @JsonSubTypes.Type(value=BytedanceByteappSNSUserToken.class, name="BYTEDANCE_BYTEAPP")})
public class SNSUserToken
implements TokenNamed {
    public static final String NAME = "SNSUserToken";
    private SNSType type;
    private String appid;
    private Instant expiresAt;
    private Instant issuedAt;

    protected SNSUserToken(SNSType type) {
        this.type = type;
    }

    @Override
    public String name() {
        return NAME;
    }

    private boolean verifyExp(Instant exp, Instant now) {
        return Objects.nonNull(exp) && exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        }
    }

    public String toString() {
        return "SNSUserToken(type=" + this.getType() + ", appid=" + this.getAppid() + ", expiresAt=" + this.getExpiresAt() + ", issuedAt=" + this.getIssuedAt() + ")";
    }

    public SNSType getType() {
        return this.type;
    }

    public String getAppid() {
        return this.appid;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public void setType(SNSType type) {
        this.type = type;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }
}

