package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.Nullable;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

/**
 * 微信用户凭据 （写入cookie）
 * wx-token与UserToken是独立的，可以同时存在，且非绑定状态
 */
@ToString(callSuper = true)
@Getter
@Setter
public class WechatOffiaccountSNSUserToken extends SNSUserToken {



    /**
     * 微信-Openid
     */
    private String openid;


    /**
     * 微信UnionID
     */
    private @Nullable String unionId;


    public WechatOffiaccountSNSUserToken() {
        super(SNSType.WECHAT_OFFIACCOUNT);
    }


    public static WechatOffiaccountSNSUserToken issue(String appid, String openid, String unionId) {
        var token = new WechatOffiaccountSNSUserToken();
        var now = Instant.now();
        var expiresAt = now.plus(365 * 24, ChronoUnit.MINUTES);
        token.setAppid(appid);
        token.setOpenid(openid);
        token.setUnionId(unionId);
        token.setIssuedAt(now);
        token.setExpiresAt(expiresAt);
        return token;
    }

}
