package org.beast.security.core;

import lombok.*;
import org.springframework.lang.Nullable;

import java.util.List;

@Getter
@Setter
@ToString(callSuper = true)
public class WechatOffiaccountSNSToken extends SNSToken {

    public static final String WECHAT_SCOPE_BASE = "snsapi_base";
    public static final String WECHAT_SCOPE_USERINFO = "snsapi_userinfo";

    /**
     * 公众号 用户唯一标识
     */
    private String openid;


    /**
     * 授权作用域
     * - snsapi_base
     * - snsapi_userinfo
     */
    private List<String> scope;

    /**
     * 访问TOKEN, 通过标识来访问 授权信息
     */
    private String accessToken;

    /**
     * 微信UnionID
     */
    private @Nullable String unionId;

    public WechatOffiaccountSNSToken() {
        super(SNSType.WECHAT_OFFIACCOUNT);
    }


    public static WechatOffiaccountSNSToken issue(String appid, String openid, List<String> scope, String accessToken, @Nullable String unionId) {
        var token = new WechatOffiaccountSNSToken();
        token.setAppid(appid);
        token.setOpenid(openid);
        token.setScope(scope);
        token.setUnionId(unionId);
        token.setAccessToken(accessToken);
        return token;
    }


    public boolean hasUserinfoScope() {
        return this.scope.contains(WECHAT_SCOPE_USERINFO);
    }

}
