package org.beast.security.core;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;


/**
 */
@ToString
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = AlipayAliappSNSToken.class, name = "ALIPAY_ALIAPP"),
        @JsonSubTypes.Type(value = WechatWebSNSToken.class, name = "WECHAT_WEB"),
        @JsonSubTypes.Type(value = WechatOffiaccountSNSToken.class, name = "WECHAT_OFFIACCOUNT"),
        @JsonSubTypes.Type(value = WechatWeappSNSToken.class, name = "WECHAT_WEAPP"),
        @JsonSubTypes.Type(value = WechatUnionSNSToken.class, name = "WECHAT_UNION"),
        @JsonSubTypes.Type(value = BytedanceByteappSNSToken.class, name = "BYTEDANCE_BYTEAPP"),
})
@Getter
@Setter
public abstract class SNSToken implements TokenNamed {
    public static final String NAME = "SNSToken";
    /**
     * SNS应用ID
     * - 支付宝应用ID
     * - 微信开放平台 appId
     * - 微信公众号 appId
     * - 微信小程序 appId
     * - 字节小程序 - AppId
     */
    private String appid;

    private SNSType type;


    protected SNSToken(SNSType type) {
        this.type = type;
    }


    @Override
    public String name() {
        return NAME;
    }
}
