/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.beast.security.core.SNSType;
import org.beast.security.core.SNSUserToken;
import org.springframework.lang.Nullable;

public class WechatOffiaccountSNSUserToken
extends SNSUserToken {
    private String openid;
    @Nullable
    private String unionId;

    public WechatOffiaccountSNSUserToken() {
        super(SNSType.WECHAT_OFFIACCOUNT);
    }

    public static WechatOffiaccountSNSUserToken issue(String appid, String openid, String unionId) {
        WechatOffiaccountSNSUserToken token = new WechatOffiaccountSNSUserToken();
        Instant now = Instant.now();
        Instant expiresAt = now.plus(8760L, ChronoUnit.MINUTES);
        token.setAppid(appid);
        token.setOpenid(openid);
        token.setUnionId(unionId);
        token.setIssuedAt(now);
        token.setExpiresAt(expiresAt);
        return token;
    }

    @Override
    public String toString() {
        return "WechatOffiaccountSNSUserToken(super=" + super.toString() + ", openid=" + this.getOpenid() + ", unionId=" + this.getUnionId() + ")";
    }

    public String getOpenid() {
        return this.openid;
    }

    @Nullable
    public String getUnionId() {
        return this.unionId;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public void setUnionId(@Nullable String unionId) {
        this.unionId = unionId;
    }
}

