/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import java.util.List;
import org.beast.security.core.SNSToken;
import org.beast.security.core.SNSType;
import org.springframework.lang.Nullable;

public class WechatOffiaccountSNSToken
extends SNSToken {
    public static final String WECHAT_SCOPE_BASE = "snsapi_base";
    public static final String WECHAT_SCOPE_USERINFO = "snsapi_userinfo";
    private String openid;
    private List<String> scope;
    private String accessToken;
    @Nullable
    private String unionId;

    public WechatOffiaccountSNSToken() {
        super(SNSType.WECHAT_OFFIACCOUNT);
    }

    public static WechatOffiaccountSNSToken issue(String appid, String openid, List<String> scope, String accessToken, @Nullable String unionId) {
        WechatOffiaccountSNSToken token = new WechatOffiaccountSNSToken();
        token.setAppid(appid);
        token.setOpenid(openid);
        token.setScope(scope);
        token.setUnionId(unionId);
        token.setAccessToken(accessToken);
        return token;
    }

    public boolean hasUserinfoScope() {
        return this.scope.contains(WECHAT_SCOPE_USERINFO);
    }

    public String getOpenid() {
        return this.openid;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public String getUnionId() {
        return this.unionId;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setUnionId(@Nullable String unionId) {
        this.unionId = unionId;
    }

    @Override
    public String toString() {
        return "WechatOffiaccountSNSToken(super=" + super.toString() + ", openid=" + this.getOpenid() + ", scope=" + this.getScope() + ", accessToken=" + this.getAccessToken() + ", unionId=" + this.getUnionId() + ")";
    }
}

