package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 微信用户凭据 （写入cookie）
 * wx-token与UserToken是独立的，可以同时存在，且非绑定状态
 */
@ToString(callSuper = true)
@Getter
@Setter
public class WechatWeappSNSUserToken extends SNSUserToken {


    /**
     * 微信小程序-OpenId
     */
    private String openid;

    /**
     * 微信UnionID
     */
    private String unionId;


    public WechatWeappSNSUserToken() {
        super(SNSType.WECHAT_WEAPP);
    }


}
