package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.Nullable;

@Getter
@Setter
@ToString(callSuper = true)
public class WechatUnionSNSToken extends SNSToken {

    /**
     * 微信UnionID
     */
    private @Nullable String unionId;

    public WechatUnionSNSToken() {
        super(SNSType.WECHAT_UNION);
    }

    public static WechatUnionSNSToken valueOf(String appid, String unionId) {
        var token = new WechatUnionSNSToken();
        token.setAppid(appid);
        token.setUnionId(unionId);
        return token;
    }
}
