package org.beast.security.core.codec;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SignatureException;
import org.beast.security.core.exception.IllegalTokenException;

import java.security.Key;

public abstract class AbstractJWTTokenParser<T> {
    private Key key;

    public AbstractJWTTokenParser(Key key) {
        this.key = key;
    }

    protected abstract T read(Claims claims);

    public T parse(String jwtString) {
        try {
            Jws<Claims> jws = Jwts.parser().setSigningKey(key).parseClaimsJws(jwtString);
            Claims claims = jws.getBody();
            return read(claims);
        } catch (JwtException e) {
            throw new IllegalTokenException("illegal jwt", e);
        }
    }
}
