/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core.access.permission;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.beast.security.core.access.permission.Permission;
import org.springframework.util.ObjectUtils;

public class WildcardPermission
implements Permission,
Serializable {
    protected static final String WILDCARD_TOKEN = "*";
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    private List<Set<String>> parts;

    protected WildcardPermission() {
    }

    public WildcardPermission(String wildcardString) {
        this.setParts(wildcardString);
    }

    protected void setParts(String wildcardString) {
        if (ObjectUtils.isEmpty((Object)wildcardString)) {
            throw new IllegalArgumentException("wildcard string cannot be empty");
        }
        Iterable parts = Splitter.on((String)PART_DIVIDER_TOKEN).split((CharSequence)wildcardString);
        this.parts = Lists.newArrayList();
        parts.forEach(part -> {
            HashSet subparts = Sets.newHashSet((Object[])part.split(SUBPART_DIVIDER_TOKEN));
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers");
            }
            this.parts.add(subparts);
        });
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers");
        }
    }

    protected List<Set<String>> getParts() {
        return this.parts;
    }

    protected void setParts(List<Set<String>> parts) {
        this.parts = parts;
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof WildcardPermission)) {
            return false;
        }
        WildcardPermission wp = (WildcardPermission)p;
        List<Set<String>> parts = this.getParts();
        List<Set<String>> otherParts = wp.getParts();
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (parts.size() > i) {
                Set<String> part = parts.get(i);
                if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                    return false;
                }
            } else {
                return true;
            }
            ++i;
        }
        while (i < parts.size()) {
            Set<String> part = parts.get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return Joiner.on((String)PART_DIVIDER_TOKEN).join(this.parts.stream().map(part -> Joiner.on((String)SUBPART_DIVIDER_TOKEN).join((Iterable)part)).iterator());
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardPermission) {
            WildcardPermission wp = (WildcardPermission)o;
            return this.parts.equals(wp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

