package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.Nullable;

/**
 * 微信用户凭据 （写入cookie）
 * wx-token与UserToken是独立的，可以同时存在，且非绑定状态
 */
@ToString(callSuper = true)
@Getter
@Setter
public class WechatOffiAccountSNSUserToken extends SNSUserToken {



    /**
     * 微信-Openid
     */
    private String openid;


    /**
     * 微信UnionID
     */
    private @Nullable String unionId;


    public WechatOffiAccountSNSUserToken() {
        super(SNSType.WECHAT_OFFIACCOUNT);
    }


}
