package org.beast.security.core;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.beast.security.core.exception.TokenExpiredException;

import java.security.Principal;
import java.time.Instant;

/**
 * 用户凭据
 * 统一cookie命名  u-token
 */
//, Principal
@ToString
@Getter
@Setter
@EqualsAndHashCode
public class UserToken implements TokenNamed {

    private String appId;

    private long uid;

    /**
     * 发行时间：
     * - 网关发行时间
     * - 代理发行时间
     */
    private Instant issuedAt;

    private Instant expiresAt;

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }
    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        };
    }

//    @Override
//    public String getName() {
//        return "UserToken";
//    }
}
