/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core.codec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.beast.security.core.codec.TokenCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public abstract class DESTokenCodec<T>
implements TokenCodec<T> {
    private static final Logger log = LoggerFactory.getLogger(DESTokenCodec.class);
    private final Class<T> tokenClazz;
    private static final String CIPHER_TRANSFORMATION = "DESede/ECB/PKCS5Padding";
    private static final String ALGORITHM = "DESede";
    private final Key secretKey;
    private final ThreadLocal<Cipher> encryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
        Cipher encryptCipher = null;
        try {
            encryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            encryptCipher.init(1, this.secretKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return encryptCipher;
    });
    private final ThreadLocal<Cipher> decryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
        Cipher decryptCipher = null;
        try {
            decryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            decryptCipher.init(2, this.secretKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return decryptCipher;
    });
    private static ObjectMapper MAPPER = new ObjectMapper();

    public DESTokenCodec(Class<T> tokenClazz, String hexKey) {
        this.tokenClazz = tokenClazz;
        try {
            byte[] key = Hex.decodeHex((String)hexKey);
            DESedeKeySpec deSedeKeySpec = new DESedeKeySpec(key);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            this.secretKey = secretKeyFactory.generateSecret(deSedeKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String encode(@NonNull T token) {
        try {
            byte[] data = MAPPER.writeValueAsBytes(token);
            Cipher encryptCipher = this.encryptCipherThreadLocal.get();
            return Hex.encodeHexString((byte[])encryptCipher.doFinal(data));
        }
        catch (Exception e) {
            log.warn("encode exception", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    @Override
    public T decode(@NonNull String tokenString) {
        try {
            Cipher decryptCipher = this.decryptCipherThreadLocal.get();
            byte[] data = decryptCipher.doFinal(Hex.decodeHex((String)tokenString));
            return (T)MAPPER.readValue(data, this.tokenClazz);
        }
        catch (Exception e) {
            log.warn("decode exception", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    static {
        MAPPER.registerModule((Module)new JavaTimeModule());
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        MAPPER.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        MAPPER.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

