/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSTokenType;
import org.beast.security.core.SNSType;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.WechatOffiAccountSNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;

public class SNSIdentity {
    private SNSType type;
    private String appid;
    private String openid;

    public SNSIdentity() {
    }

    public static SNSIdentity valueOf(SNSUserToken userToken) {
        SNSTokenType type = userToken.getType();
        if (userToken instanceof WechatWeappSNSUserToken) {
            WechatWeappSNSUserToken weappSNSUserToken = (WechatWeappSNSUserToken)userToken;
            return SNSIdentity.builder().type(SNSType.WECHAT_WEAPP).appid(weappSNSUserToken.getAppid()).openid(weappSNSUserToken.getOpenid()).build();
        }
        if (userToken instanceof WechatOffiAccountSNSUserToken) {
            WechatOffiAccountSNSUserToken offiAccountSNSUserToken = (WechatOffiAccountSNSUserToken)userToken;
            return SNSIdentity.builder().type(SNSType.WECHAT_OFFIACCOUNT).appid(offiAccountSNSUserToken.getAppid()).openid(offiAccountSNSUserToken.getOpenid()).build();
        }
        if (userToken instanceof BytedanceByteappSNSUserToken) {
            BytedanceByteappSNSUserToken byteappSNSUserToken = (BytedanceByteappSNSUserToken)userToken;
            return SNSIdentity.builder().type(SNSType.BYTEDANCE_BYTEAPP).appid(byteappSNSUserToken.getAppid()).openid(byteappSNSUserToken.getOpenid()).build();
        }
        throw new UnsupportedOperationException(String.format("type: [%s] unable support", new Object[]{type}));
    }

    SNSIdentity(SNSType type, String appid, String openid) {
        this.type = type;
        this.appid = appid;
        this.openid = openid;
    }

    public static SNSIdentityBuilder builder() {
        return new SNSIdentityBuilder();
    }

    public SNSType getType() {
        return this.type;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getOpenid() {
        return this.openid;
    }

    public void setType(SNSType type) {
        this.type = type;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SNSIdentity)) {
            return false;
        }
        SNSIdentity other = (SNSIdentity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SNSType this$type = this.getType();
        SNSType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$appid = this.getAppid();
        String other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
            return false;
        }
        String this$openid = this.getOpenid();
        String other$openid = other.getOpenid();
        return !(this$openid == null ? other$openid != null : !this$openid.equals(other$openid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SNSIdentity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SNSType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        String $openid = this.getOpenid();
        result = result * 59 + ($openid == null ? 43 : $openid.hashCode());
        return result;
    }

    public String toString() {
        return "SNSIdentity(type=" + this.getType() + ", appid=" + this.getAppid() + ", openid=" + this.getOpenid() + ")";
    }

    public static class SNSIdentityBuilder {
        private SNSType type;
        private String appid;
        private String openid;

        SNSIdentityBuilder() {
        }

        public SNSIdentityBuilder type(SNSType type) {
            this.type = type;
            return this;
        }

        public SNSIdentityBuilder appid(String appid) {
            this.appid = appid;
            return this;
        }

        public SNSIdentityBuilder openid(String openid) {
            this.openid = openid;
            return this;
        }

        public SNSIdentity build() {
            return new SNSIdentity(this.type, this.appid, this.openid);
        }

        public String toString() {
            return "SNSIdentity.SNSIdentityBuilder(type=" + this.type + ", appid=" + this.appid + ", openid=" + this.openid + ")";
        }
    }
}

