package org.beast.security.core.auth.convertor;

import org.beast.security.core.auth.permission.WildcardPermission;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

import java.util.ArrayList;
import java.util.List;

public class PermissionConverters {

    public static List<?> getConvertersToRegister() {

        List<Object> converters = new ArrayList<>();
        converters.add(WildcardPermissionToStringConverter.INSTANCE);
        converters.add(StringToWildcardPermissionConvert.INSTANCE);
        return converters;
    }


    enum WildcardPermissionToStringConverter implements Converter<WildcardPermission, String> {
        INSTANCE;

        @Override
        public String convert(@Nullable WildcardPermission source) {
            return source == null? null : source.toString();
        }
    }

    enum StringToWildcardPermissionConvert implements Converter<String, WildcardPermission> {
        INSTANCE;

        @Override
        public WildcardPermission convert(@Nullable String source) {
            return source == null? null : new WildcardPermission(source);
        }
    }

}
