package org.beast.security.core;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.time.Instant;


/**
 */
@ToString
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = AlipaySNSToken.class, name = "ALIPAY"),
        @JsonSubTypes.Type(value = WechatWebSNSToken.class, name = "WECHAT_WEB"),
        @JsonSubTypes.Type(value = WechatOffiAccountSNSToken.class, name = "WECHAT_OFFIACCOUNT"),
        @JsonSubTypes.Type(value = WechatWeappSNSToken.class, name = "WECHAT_WEAPP"),
        @JsonSubTypes.Type(value = BytedanceByteappSNSToken.class, name = "BYTEDANCE_BYTEAPP"),
})
@Getter
@Setter
public abstract class SNSToken implements TokenNamed {
    private static final String NAME = "SNSToken";
    /**
     * SNS应用ID
     * - 支付宝应用ID
     * - 微信开放平台 appId
     * - 微信公众号 appId
     * - 微信小程序 appId
     * - 字节小程序 - AppId
     */
    private String appid;

    private SNSTokenType type;


    protected SNSToken(SNSTokenType type) {
        this.type = type;
    }


    @Override
    public String name() {
        return NAME;
    }
}
