package org.beast.security.core.util;

import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.io.IOUtils;
import org.springframework.util.ResourceUtils;

import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;

public class KeySpecUtils {

    public static PrivateKey readPrivateKey(String resource) {
        try {
            URL url = ResourceUtils.getURL(resource);
            byte[] keyBytes = IOUtils.toByteArray(url);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        } catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static PublicKey readPublicKey(String resource) {
        try {
            URL url = ResourceUtils.getURL(resource);
            byte[] keyBytes = IOUtils.toByteArray(url);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        } catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}
