package org.beast.security.core.auth.annotation;


import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.beast.security.core.auth.UnauthenticatedException;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;

public class RequireAuthenticatedMethodInterceptor implements MethodInterceptor {

    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        AccessibleObject accessibleObject = methodInvocation.getStaticPart();
        Method method = methodInvocation.getMethod();

        if (accessibleObject.isAnnotationPresent(RequireAuthenticated.class) ||
                method.isAnnotationPresent(RequireAuthenticated.class))  {
            //确保身份认证



            String message = accessibleObject.getClass().getName() + "." + method.getName() + " require authenticated.";
            throw new UnauthenticatedException(message);
        }
        return methodInvocation.proceed();
    }
}
